 ; Ŀ
 ;   Pj - join two polylines, lines, and/or arcs.                          
 ;   Copyright 1996, 2008 by Rocket Software Ltd.                          
 ;   Caution - do not use while in the garment of the same name.           
 ; 

 ; Ŀ
 ;   Subroutine Cloz - find the closest two points in a list.              
 ;   Argument: Liss, a list: ((point ename) ... )                          
 ;   Calls nothing.                                                        
 ;   Returns a list with the two closest points moved to the front.        
 ; 
 (DEFUN CLOZ (liss / num sub subnum pa enam csub disa mindis min1 min2 gnu)
 ; Ŀ
 ;   Find the closest two points in Liss.                                  
 ; 
  (setq num 0)
  (while (setq sub (nth num liss))
         (setq subnum (setq num (1+ num)))
         (setq pa (car sub))
         (setq enam (cadr sub))
         (while (setq csub (nth subnum liss))
                (setq subnum (1+ subnum))
                (setq disa (distance pa (car csub)))
                (if (and (or (null mindis) (< disa mindis))
                         (not (equal enam (cadr csub))))
                    (progn
                         (setq mindis disa)
                         (setq min1 sub)
                         (setq min2 csub)))))
 ; Ŀ
 ;   Remove them from Liss.                                                
 ; 
  (setq num 0)
  (while (setq sub (nth num liss))
         (if (not (or (equal sub min1) (equal sub min2)))
             (setq gnu (cons sub gnu)))
         (setq num (1+ num)))
 ; Ŀ
 ;   Add them back to the beginning.                                       
 ; 
 (cons min1 (cons min2 gnu)))
 ; Ŀ
 ;   Subroutine Cloz end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Enzo: Find the endpoints of a line type entity.            
 ;   Takes one argument, the arc ename, returns a list of the endpoints.   
 ; 
 (DEFUN ENZO (enam / typ entt end1 end2 ends arcdat)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (cond ((= typ "POLYLINE")
         (setq end1 (cdr (assoc 10 (entget (entnext enam)))))
         (setq end2 (cdr (assoc 10 (entget (lastv enam))))))
        ((= typ "LWPOLYLINE")
         (setq ends (wendy enam))
         (setq end1 (car ends))
         (setq end2 (cadr ends)))
        ((= typ "LINE")
         (setq end1 (cdr (assoc 10 entt)))
         (setq end2 (cdr (assoc 11 entt))))
        ((= typ "ARC")
         (setq end1 (car (setq arcdat (vrtarc enam))))
         (setq end2 (cadr arcdat))))
  (list (list end1 enam) (list end2 enam)))
 ; Ŀ
 ;   Subroutine Enzo end.                                                  
 ; 

 ; Ŀ
 ;   Subroutine Lastv - returns the ename of the last vertex of the        
 ;   polyline whose ename was passed as the sole argument.                 
 ; 
 (DEFUN LASTV (enam / goon next typp)
  (setq goon T)
  (while (and goon
              (setq typp (cdr (assoc 0 (entget (setq next (entnext enam)))))))
         (if (= typp "SEQEND")
             (setq goon ())
             (setq enam next)))
 enam)
 ; Ŀ
 ;   Lastv end.                                                            
 ; 

 ; Ŀ
 ;   Readde - remove all sublists containing a given ename from a list,    
 ;   add in a new one.                                                     
 ;   Arguments: Enamk, the ename to remove, or nil.                        
 ;              Enama, the ename to add, or nil.                           
 ;   Calls Enzo. Returns a new list.                                       
 ; 
 (DEFUN READDE (enamk enama ptlist / num gnu sub)
 ; Ŀ
 ;   Remove sublists for the old enam, enamk, unless it is nil.            
 ;   Do this first in case the two enames are the same.                    
 ; 
  (setq num 0)
  (while (setq sub (nth num ptlist))
         (if (/= enamk (cadr sub))
             (setq gnu (cons sub gnu)))
         (setq num (1+ num)))
 ; Ŀ
 ;   If enama isn't nil, add in the two sublists for it.                   
 ; 
 (if enama
     (append gnu (enzo enama))
     gnu))
 ; Ŀ
 ;   Readde end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Stex - see if the ename passed as an argument still has a  
 ;   corresponding entity.                                                 
 ;   Prints an error message if the entity exists, but returns T if so     
 ;   and nil otherwise.                                                    
 ; 
 (DEFUN STEX (enam / exp)
  (if (and (= (type enam) 'ENAME) (setq exp (entget enam)))
      (prompt "Operation unsuccessful - no new polyline segments added."))
 (if exp t ()))
 ; Ŀ
 ;   Stex.                                                                 
 ; 

 ; Ŀ
 ;   Subroutine Vrtarc: Find the endpoints of an arc.                      
 ;   Takes one argument, the arc ename, returns a list of the endpoints.   
 ; 
 (DEFUN VRTARC (enam / arcent cent stangl endang radd end1 end2)
  (setq arcent (entget enam))
  (setq cent (cdr (assoc 10 arcent)))
  (setq stangl (cdr (assoc 50 arcent)))
  (setq endang (cdr (assoc 51 arcent)))
  (setq radd (cdr (assoc 40 arcent)))
  (setq end1 (polar cent stangl radd))
  (setq end2 (polar cent endang radd))
 (list end1 end2))
 ; Ŀ
 ;   Vrtarc end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Wendy: Find the endpoints of an LwPolyline.                
 ;   Takes one argument, the ename, returns a list of the endpoints.       
 ; 
 (DEFUN WENDY (enam / entt eleva num sub tenlst end1 end2)
  (if (/= (type last) 'SUBR)
      (pjer "Unable to run: Last subroutine has been redefined."))
  (setq entt (entget enam))
  (if (null (setq eleva (cdr (assoc 38 entt))))
      (setq eleva 0))
  (setq num 0)
  (while (setq sub (nth num entt))
         (if (= (car sub) 10)
             (setq tenlst (cons sub tenlst)))
         (setq num (1+ num)))
  (setq end1 (append (cdar tenlst) (list eleva)))
  (setq end2 (append (cdr (last tenlst)) (list eleva)))
 (list end1 end2))
 ; Ŀ
 ;   Wendy end.                                                            
 ; 

 ; Ŀ
 ;   Pj.                                                                   
 ; 
 (DEFUN C:PJ (/ *error* ss num enam sev ptlist len sub1 sub2 ekill enam3 enam1
                                                             enam2 p1 p2 elast)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
 (defun *error* (shk)
  (command "undo" "end")
  (if shk (write-line shk))
 (princ))
 ; Ŀ
 ;   Get some entities.                                                    
 ; 
  (setq ss (ssget (list (cons 0 "polyline,lwpolyline,line,arc"))))
 ; Ŀ
 ;   Remove closed polylines.                                              
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (if (and (setq sev (cdr (assoc 70 (entget enam))))
                  (= 1 (logand 1 sev)))
             (progn
                  (ssdel enam ss)
                  (prompt "\nRemoving closed polyline."))
             (setq num (1+ num))))
 ; Ŀ
 ;   Make the ss into a list ((endpoint enam) ...).                        
 ;   There will be two endpoints, and thus two sublists, per entity.       
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq ptlist (append ptlist (enzo enam)))
         (setq num (1+ num)))
 ; Ŀ
 ;   Find the two closest endpoints in the list.                           
 ; 
  (setq len (sslength ss))
  (setq num 0)
  (while (and (setq ptlist (cloz ptlist))
              (setq sub1 (cadr ptlist))
              (setq sub2 (car ptlist))
              (< num (* 2 len)))
         (setq num (1+ num))
         (setq ekill ())
         (setq enam3 ())
         (setq ptlist (cddr ptlist))
         (setq enam1 (cadr sub1))
         (setq enam2 (cadr sub2))
         (setq p1 (car sub1))
         (setq p2 (car sub2))
 ;       (grdraw '(0 0) p1 1)
 ;       (grdraw '(0 0) p2 2)
 ; Ŀ
 ;   If the first entity wasn't a polyline, make it into one.              
 ;   Then update the ((point ename) ...) list.                             
 ;   (Adding segments to a polyline doesn't change the ename, but making   
 ;   a line into a polyline does.)                                         
 ; 
         (if (not (member (cdr (assoc 0 (entget enam1)))
                         '("POLYLINE" "LWPOLYLINE")))
             (progn
                  (command "pedit" enam1 "y" "")
                  (setq ekill enam1)
                  (setq enam1 (entlast))
                  (setq ptlist (readde ekill enam1 ptlist))))
 ; Ŀ
 ;   If the two endpoints are equal, join the entities.                    
 ; 
         (if (equal p1 p2)
             (command "pedit" enam1 "j" enam2 "" "")
             (progn
                  (setq elast (entlast))
                  (command ".line" p1 p2 "")
 ; Ŀ
 ;   If enam3 equals elast then no new line entity was created.            
 ;   This is based on the idea that acad won't create a zero length line.  
 ;   Of course pedit and line may have different ideas on what zero is.    
 ;                                                                         
 ;   Better: join, if no join then try again with a line.                  
 ; 
                  (setq enam3 (entlast))
                  (if (equal elast enam3)
                      (command "pedit" enam1 "j" enam2 "" "")
                      (command "pedit" enam1 "j" enam2 enam3 "" ""))
 ; Ŀ
 ;   If the new line still exits then it wasn't joined, so delete it.      
 ;   (it was not added to Ptist).                                          
 ; 
                  (if (stex enam3) (entdel enam3))))
 ; Ŀ
 ;   At this point the entity enam1 may have changed, so remove it from    
 ;   the list (there will be one copy still there) and re-add it.          
 ; 
         (setq ptlist (readde enam1 enam1 ptlist))
 ; Ŀ
 ;   If enam2 still exist then it wasn't joined, so add it back to         
 ;   the list.  Bear in mind that this is bad.                             
 ; 
         (if (stex enam2)
             (setq ptlist (cons sub2 ptlist))
 ; Ŀ
 ;   If enam2 doesn't exist then remove it from Ptlist.                    
 ; 
             (setq ptlist (readde enam2 nil ptlist))))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error* nil)
 (princ))